; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def sec
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.                                                     ; Carregar Energia 01
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| AI |-------------------------------------------------------------
[Command]
name = "CPU1"
command = U,U,U,U,F,F,F,F
time = 1

[Command]
name = "CPU2"
command = U,D,DB,U,F,F,F,F,D
time = 1

[Command]
name = "CPU3"
command = U,D,F,U,F,F,F,F,U,D,U
time = 1

[Command]
name = "CPU4"
command = U,D,F,U,F,F,F,F,U,D,B
time = 1

[Command]
name = "CPU5"
command = B,D,F,U,F,F,F,F,U,D,U
time = 1

[Command]
name = "CPU6"
command = U,D,F,U,B,F,B,F,U,D,U
time = 1

[Command]
name = "CPU7"
command = F,B,F,U,B,F,B,F,U,D,U
time = 1


[Command]
name = "CPU8"
command = F,B,F,U,B,F,B,F,U,D,U,B
time = 1

[Command]
name = "CPU9"
command = F,B,F,U,B,F,B,F,U,D,U,B,U
time = 1

[Command]
name = "CPU10"
command = F,B,F,U,B,F,B,F,U,D,U,B,U,D
time = 1

[Command]
name = "CPU11"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,F
time = 1

[Command]
name = "CPU12"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B
time = 1

[Command]
name = "CPU13"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,F,DB
time = 1

[Command]
name = "CPU14"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF
time = 1

[Command]
name = "CPU15"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF
time = 1

[Command]
name = "CPU16"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F
time = 1

[Command]
name = "CPU17"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,a
time = 1





;-------------------golpes-----------------------------------------------



[Command]
name = "hold_s"
command = /z
time = 1

[command]
name = "tiro01"
command = D,D,a
time = 25

[command]
name = "tiro02"
command = D,D,b
time = 25


[command]
name = "leishu1"
command = D,F,x
time = 15

[command]
name = "granada"
command = D,F,y
time = 15


[command]
name = "leishuar"
command = D,F,x
time = 15

[command]
name = "leishuar2"
command = D,F,y
time = 15


[command]
name = "trava1"
command = D,B,x
time = 15

[command]
name = "trava2"
command = D,B,y
time = 15

[command]
name = "barreira"
command = x+a
time = 15

[command]
name = "aura"
command = D,F,D,F,x
time = 25


[Command]
name = "golpechue01"
command = D,B, a
time = 20

[Command]
name = "golpechue02"
command = D,F,D,F,y
time = 30

[Command]
name = "golpechue03"
command = D,B, b
time = 20

[Command]
name = "golpechue04"
command = D,F, b
time = 20

[Command]
name = "golpechue05"
command = D,F, a
time = 20

[Command]
name = "golpechue06"
command = D,F, b
time = 20

[Command]
name = "golpechue07"
command = D,F, a
time = 20

[Command]
name = "Superpulo"
command = D, $U
time = 10

[Command]
name = "Superpulo"
command = ~D, UF
time = 15

[Command]
name = "Superpulo"
command = ~D, UB
time = 15

[Command]
name = "FF1"     ;Required (do not remove)
command = F,F, a
time = 20

[Command]
name = "FF2"     ;Required (do not remove)
command = F,F, b
time = 20

[Command]
name = "FF3"     ;Required (do not remove)
command = F,DF,F, a
time = 20

[Command]
name = "FF4"     ;Required (do not remove)
command = F,DF,F, b
time = 20


[command]
name = "tirosp"
command = D,F,D,F, b
time = 25

[command]
name = "adeus"
command = D,F,D,F,y+b
time = 25


[Command]
name = "Contchute"
command = /$D,y
time = 1
buffer.time = 5

[Command]
name = "SocoChao"
command = y+b
time = 25

[Command]
name = "Empurra"
command = y+b
time = 20


[Command]
name = "Golpe_Rapido01"
command = D,B,  a
time = 25

[Command]
name = "Golpe_Rapido02"
command = D,B,  b
time = 25

[command]
name = "Sennen Goroshi"
command = z
time = 15

[Command]
name = "hold_s"
command = /z
time = 1

;===================< DIR >===================

[Command]
name = "fwd"
command = F
time = 1
[Command]
name = "back"
command = B
time = 1
[Command]
name = "up"
command = U
time = 1
[Command]
name = "down"
command = D
time = 1


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1


[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;=========================================================================

[state -1]
type = changestate
triggerall = random < 100
triggerall = var(59) = 1
triggerall = stateno != 40
triggerall = statetype != a
trigger1 = (p2movetype = a) && (p2statetype != a) && (enemy, numhelper >= 1)
trigger1 = ctrl = 1
trigger2 = (p2movetype = a) && (p2statetype != a) && (enemy, numproj >= 1)
trigger2 = ctrl = 1
value = 40

[state -1]
type = varset
trigger1 = var(59) = 1
trigger1 = (p2movetype = a) && (p2statetype != a) && (enemy, numproj >= 1)
trigger1 = ctrl = 1
v = 3
value = 1


[State -1, Inteligencia]
type = VarSet
trigger1  = command = "CPU1"
trigger2  = command = "CPU2"
trigger3  = command = "CPU3"
trigger4  = command = "CPU4"
trigger5  = command = "CPU5"
trigger6  = command = "CPU6"
trigger7  = command = "CPU7"
trigger8  = command = "CPU8"
trigger8  = command = "CPU9"
trigger8  = command = "CPU10"
trigger11  = command = "CPU11"
trigger12  = command = "CPU12"
trigger13  = command = "CPU13"
trigger14  = command = "CPU14"
trigger15  = command = "CPU15"
trigger16  = command = "CPU16"
trigger17  = command = "CPU17"
trigger18  = command = "CPU18"
trigger19  = command = "CPU19"
trigger20  = command = "CPU20"
trigger21  = command = "CPU21"
v = 59
value = 1

[state -1]
type = changestate
value = 0
triggerall = var(59) = 1
triggerall = roundstate = 3
trigger1 = statetype != a
trigger1 = ctrl

;============================================================================================



;------------------COMBOS SENSUI-------------------------------------------
;ground combo 0--------------------------------------------------
[state -1,1]
type = changestate
value = 200
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]
trigger2 = random < 50

[state -1]
type = changestate
value = 201
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 200
trigger1 = movecontact
trigger1 = random < 20

[state -1]
type = changestate
value = 202
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 201
trigger1 = movecontact
trigger1 = random < 20

[state -1]
type = changestate
value = 230
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 200
trigger1 = movecontact
trigger1 = random < 20

[state -1]
type = changestate
value = 201
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 200
trigger1 = movecontact
trigger1 = random < 20

[state -1]
type = changestate
value = 230
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 203
trigger1 = movecontact
trigger1 = random < 20

[state -1]
type = changestate
value = 240
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 230
trigger1 = movecontact


;ground combo 1--------------------------------------------------


[State -3, NoWalk after Parry]
type=assertspecial
trigger1= prevstateno=708
trigger1= stateno=0 && time<7
flag= nowalk

[State -3, Standing Parry]
type = hitoverride
triggerall = var(59)>=1 && numenemy && (var(54)&524288)=0
triggerall = !IsHelper && playeridexist(var(56))
triggerall = roundstate=2 && statetype!=A
triggerall = numhelper(50000+id)
triggerall = helper(50000+id),fvar(36)>=helper(50000+id),fvar(38)
triggerall = helper(50000+id),fvar(37)>=helper(50000+id),fvar(39)
trigger1 = (ctrl||(stateno = [120,140])||stateno=21||(stateno=[0,1])||(stateno = [10,12])) || ((stateno=[708,708])) || stateno=5120
trigger1 = var(21):=1
attr = SCA,NA,SA,HA,NP,SP,HP,NT,ST,HT,AA,AP
stateno = 708
slot = 0
time = 8

[State -3, Reset Parry]
type = hitoverride
triggerall = var(59)>=1 && (var(54)&524288)=0
triggerall = !IsHelper && playeridexist(var(56))
trigger1 = (!ctrl && (stateno!=[718,718]) && stateno!=5120&&(stateno != [120,140])&&stateno!=21&&(stateno!=[0,1])&&(stateno != [10,12])) || var(20)
trigger2 = movetype!=I || (stateno=[100,106]);|| (stateno=[120,132])
trigger3 = (statetype=S || statetype=C) && var(21)!=1 && var(21)!=2
trigger4 = statetype=A && var(21)!=3
slot = 0
time = 0

[state 50000,Parry]
type = varset
triggerall = !IsHelper
trigger1 = stateno = [708,708]
fvar(39) = 708
IgnoreHitPause = 1

[state 50000,Reset Parry Var]
type = varset
triggerall = !IsHelper
triggerall = fvar(39)=708.5
trigger1 = movetype = A || ((stateno = [5000,5210]) && time>1) || (movetype = H && stateno != [120,139])
fvar(39) = 0
IgnoreHitPause = 1

;ground combo 2--------------------------------------------------

[state -1,1]
type = changestate
value = 230
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]
trigger2 = random < 50

[state -1]
type = changestate
value = 231
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 230
trigger1 = movecontact
trigger1 = random < 20

[state -1]
type = changestate
value = 232
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 231
trigger1 = movecontact
trigger1 = random < 20

;ground combo 2--------------------------------------------------

[state -1,1]
type = changestate
value = 210
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]
trigger2 = random < 50

[state -1]
type = changestate
value = 211
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 210
trigger1 = movecontact
trigger1 = random < 20

[state -1]
type = changestate
value = 212
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 211
trigger1 = movecontact
trigger1 = random < 20


;ground combo 2--------------------------------------------------

[state -1,1]
type = changestate
value = 241
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]
trigger2 = random < 50

[state -1]
type = changestate
value = 240
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 241
trigger1 = movecontact
trigger1 = random < 20

;ground combo 3--------------------------------------------------

;ground combo 4--------------------------------------------------

[state -1,1]
type = changestate
value = 400
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 50
;trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]
trigger2 = random < 50

[state -1]
type = changestate
value = 430
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 400
trigger1 = movecontact

[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
trigger1 = stateno = 430
trigger1 = movecontact


[state -1,2]
type = changestate
value = 60
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
;triggerall = power >= 500
;triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 410
trigger1 = movecontact
trigger1 = p2bodydist x < 20
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl


[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 20
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl


[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 40
trigger2 = p2bodydist x = [0,50]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 630
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 600
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 610
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 630
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 640
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 610
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 611
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 640
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 611
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 610
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl


;--------------------GolpesAI-------------------------------------------


[state -1]
type = changestate
value = 450
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 230 || stateno = 451 || stateno = 210
trigger1 = movecontact
trigger1 = random < 50


[state -1]
type = changestate
value = 450
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 410 || stateno = 451 || stateno = 210
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 451
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 450
trigger1 = movecontact
trigger1 = random < 50


[state -1]
type = changestate
value = 732;726
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 400
triggerall = time >8
trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 230 
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 732;726
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 400
triggerall = time >8
;trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 410 
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 730;726
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 400
triggerall = time >15
trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 230 || stateno = 1801 || stateno = 1802 || stateno = 250
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 730;726
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 400
triggerall = time >15
;trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 410 || stateno = 1801 || stateno = 1800 || stateno = 250
trigger1 = movecontact
trigger1 = random < 50


[state -1]
type = changestate
value = 1000
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 300
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 230 || stateno = 210
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 1000
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 300
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 410 || stateno = 210
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 1002
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 300
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 210
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 1002
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 300
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 410 || stateno = 210
trigger1 = movecontact
trigger1 = random < 50


[state -1]
type = changestate
value = 1011
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
;triggerall = power >= 300
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 1010; || stateno = 410
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 1013
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
triggerall = time >8
trigger1 = stateno = 1012
trigger1 = movecontact

[state -1]
type = changestate
value = 1200
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 1013
trigger1 = movecontact

[state -1]
type = changestate
value = 1205
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 1200
trigger1 = movecontact

[state -1]
type = changestate
value = 611
triggerall = var(59) = 1 && roundstate =2
triggerall = ctrl = 0
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 1205 || stateno = 721
trigger1 = movecontact


[state -1]
type = changestate
value = 1602
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 201 || stateno = 212
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 1602
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 201 || stateno = 212 || stateno = 200
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 1800
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 1800
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 241 || stateno = 410
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 1801
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 150
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 102 || stateno = 115 || stateno = 41
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 1800
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 150
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 102 || stateno = 115 || stateno = 41
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 701
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 150
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 610 || stateno = 640 || stateno = 611 || stateno = 1800 || stateno = 1801
trigger1 = movecontact
trigger1 = random < 50


[state -1]
type = changestate
value = 721
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 200
triggerall = time >8
trigger1 = (Movehit)
trigger1 = stateno = stateno = 640 
trigger1 = movecontact
trigger1 = random < 50


[State -1, AI Guard Push (Standing)]
type = ChangeState
triggerall = Var(59)
;triggerall = AILevel >= 4
triggerall = p2bodydist x =[0,30]
triggerall = StateType != A
triggerall = enemynear, HitDefAttr = SCA,NA,NT,NP,SA,ST,SP
trigger1 = StateNo = [150,153]
trigger1 = Time >= 8
;trigger2 = random < 10
trigger1 = random < 50+50*(BackEdgeDist < 30)
value = 160


[State -1, AI Guard Push (Standing)]
type = ChangeState
triggerall = Var(59)
;triggerall = AILevel >= 4
triggerall = p2bodydist x =[0,30]
triggerall = StateType != A
triggerall = enemynear, HitDefAttr = SCA,NA,NT,NP,SA,ST,SP
trigger1 = StateNo = [151,153]
trigger1 = Time >= 8
;trigger2 = random < 10
trigger1 = random < 50+50*(BackEdgeDist < 30)
value = 161

[State -1, AI Guard Push (Standing)]
type = ChangeState
triggerall = Var(59)
;triggerall = AILevel >= 4
triggerall = p2bodydist x =[0,30]
triggerall = StateType != S
triggerall = enemynear, HitDefAttr = SCA,NA,NT,NP,SA,ST,SP
trigger1 = StateNo = [152,153]
trigger1 = Time >= 8
;trigger2 = random < 10
trigger1 = random < 50+50*(BackEdgeDist < 30)
value = 162




;-------------------------Golpes Especiais-----------------------------

[state -1]
type = changestate
value = 3010;709
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 1500
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 1011 || stateno = 1800  || stateno = 250 || stateno = 212
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 3010;709
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 1500
triggerall = time >15
;trigger1 = (Movehit)
trigger1 = stateno = 1011 || stateno = 1800 || stateno = 250
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 710
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 1000
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 1011 || stateno = 1800
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 710
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 1000
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 1011 || stateno = 1800
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 712
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 1500
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 1011 || stateno = 1800 || stateno = 450 || stateno = 451
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 712
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 1500
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 1011 || stateno = 1800 || stateno = 450 || stateno = 451
trigger1 = movecontact
trigger1 = random < 50


[state -1]
type = changestate
value = 250
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >20
trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 210 || stateno = 460; || stateno = 451
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 460
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >20
trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 210 || stateno = 250; || stateno = 451
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 250
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >20
;trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 210 || stateno = 460; || stateno = 451
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 460
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >20
;trigger1 = (Movehit)
trigger1 = stateno = 240 || stateno = 210 || stateno = 250; || stateno = 451
trigger1 = movecontact
trigger1 = random < 50


[state -1]
type = changestate
value = 750
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 250
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 724  || stateno = 610 || stateno = 640
trigger1 = movecontact
trigger1 = random < 30

[state -1]
type = changestate
value = 750
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 250
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno =  724 || stateno = 1401  || stateno = 610 || stateno = 640
trigger1 = movecontact
trigger1 = random < 30

[state -1]
type = changestate
value = 724
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 250
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno =  611 
trigger1 = movecontact
trigger1 = random < 30


;-------------------------------------------------------------------------

;CPU0
;[State -1, Inteligencia]
;type = ChangeState
;triggerall = var(59) = 1 && roundstate =2
;triggerall = statetype != a
;triggerall = numhelper(1550) = 0
;triggerall = var(30) != 1
;triggerall = power >= 350
;trigger1 = ctrl
;trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
;trigger1 = p2bodydist x < 250
;trigger1 = p2statetype != A
;value = ifelse (p2bodydist x<100,1500,1500) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<200,1500,1500)
;value = ifelse (p2bodydist x<250,1500,1500) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)

[state -1,1]
type = changestate
value = 1500
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = numhelper(1550) = 0
triggerall = var(30) != 1
triggerall = power >= 350
triggerall = time >15
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,250]
trigger1 = random < 30
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,250]

;CPU1
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 200
trigger1 = ctrl
trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 250
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<100,450,450) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<150,450,450)
value = ifelse (p2bodydist x<200,450,450) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<250,450,450)

;CPU2
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 200
trigger1 = ctrl
trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 40
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<20,705,705) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<30,705,705)
value = ifelse (p2bodydist x<40,705,705) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)

;CPU3
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 200
trigger1 = ctrl
trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 40
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<25,70500,70500) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<35,70500,70500)
value = ifelse (p2bodydist x<45,70500,70500) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)

;CPU4
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 55 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 40
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<80,250,250) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<95,250,250)
value = ifelse (p2bodydist x<110,250,250) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)

;CPU5
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 55 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 40
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<90,460,460) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<105,460,460)
value = ifelse (p2bodydist x<125,460,460) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)


;CPU7
[State -1, Inteligencia]
type = ChangeState
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
;triggerall = numhelper(1550) = 0
;triggerall = var(30) != 1
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 95
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<85,729,729) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<95,729,729)
;value = ifelse (p2bodydist x<250,1500,1500) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)

;CPU8
[State -1, Inteligencia]
type = ChangeState
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
;triggerall = numhelper(1550) = 0
;triggerall = var(30) != 1
triggerall = power >= 200
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 55
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<55,727,727) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<65,727,727)
;value = ifelse (p2bodydist x<250,1500,1500) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)


;CPU9
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 1000
trigger1 = ctrl
trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 80
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<80,710,710) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<95,710,710)
value = ifelse (p2bodydist x<110,710,710) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)


;CPU10
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = A && movetype != H
triggerall = power >= 1000
trigger1 = ctrl
trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 80
trigger1 = p2statetype != S
value = ifelse (p2bodydist x<80,750,750) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<95,750,750)
value = ifelse (p2bodydist x<110,750,750) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)


;CPU11
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 2500
trigger1 = ctrl
trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 250
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<150,714,714) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<250,714,714)
;value = ifelse (p2bodydist x<110,750,750) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)


;CPU12
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 1500
trigger1 = ctrl
trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 250
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<120,712,712) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<220,712,712)
;value = ifelse (p2bodydist x<110,750,750) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)


;CPU13
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 200
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<105,730,730) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<200,730,730)
;value = ifelse (p2bodydist x<110,750,750) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)

;CPU14
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 300
trigger1 = ctrl
trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 200
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<105,732,732) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<200,732,732)
;value = ifelse (p2bodydist x<110,750,750) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)

;CPU14
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 1500
trigger1 = ctrl
trigger1 = random <= 50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 330
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<230,3010,3010) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<330,3010,3010)
;value = ifelse (p2bodydist x<110,750,750) ;escolhe o golpe a ser executado
;value = ifelse (p2bodydist x<250,705,705)



;CPU16
[State -1, powercharge]
type=changestate
value=500
trigger1= var(59)<=0
trigger1= command= "hold_s"; && command="holdy"
trigger1= roundstate=2 && statetype!=A && ctrl
trigger1= power<const(data.power) && power<powermax && !var(20)
trigger1 = random <= 30
trigger1 = p2bodydist x < 50


;CPU17
[State -1, run/dash]
type=changestate
value=ifelse(command="FF",100,105)
trigger1= var(59)<=0
trigger1= command="FF" || command="BB"
trigger1= roundstate=2 && (stateno!=[100,106]) && statetype=S && ctrl


;===========================================================================

[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl


[State -1, correndo frente ar]
type = ChangeState
value = 102
trigger1 = command = "FF"
trigger1 = statetype = A
trigger1 = ctrl

[State -1, correndo traz ar]
type = ChangeState
value = 115
trigger1 = command = "BB"
trigger1 = statetype = A
trigger1 = ctrl

[State -1:Super pulo]
type = ChangeState
value = 60
triggerall = !var(59)&&command = "Superpulo"
trigger1 = (statetype = S) && (ctrl)


[State -1, Guard Push stand]
type = ChangeState
value = 160
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = S
trigger1 = stateno = [150,153]

[State -1, Guard Push crouch]
type = ChangeState
value = 161
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = C
trigger1 = stateno = [150,153]

[State -1, Guard Push aerial]
type = ChangeState
value = 162
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = A
trigger1 = stateno = [154,155]


;[State 1960, 5]
;type = ChangeState
;Triggerall = AnimElem = 3,>0
;trigger1 = stateno=812
;trigger1 = var(58) = [0,89]
;value = 724


[State -1, ]
type = ChangeState
value = 250
triggerall = var(59) <= 0
triggerall = command = "FF2"
;triggerall = command != "holddown"
triggerall = stateno = 100
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 460
triggerall = var(59) <= 0
triggerall = command = "FF1"
;triggerall = command != "holddown"
triggerall = stateno = 100
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = movecontact
trigger3 = (stateno = 210) && movecontact
trigger4 = (stateno = 240) && movecontact

;---------------------------------------------------------------------------

[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl



[State -1, powercharge]
type=changestate
value=500
trigger1= var(59)<=0
trigger1= command="hold_s"; && command="holdy"
trigger1= roundstate=2 && statetype!=A && ctrl
trigger1= power<const(data.power) && power<powermax && !var(20)

;-------------------------golpes Especiais------------------------------------


[State -1, ]
type = ChangeState
value = 714
trigger1 = command = "adeus"
triggerall = power >= 2500
trigger1 = statetype = S
trigger1 = ctrl

[State -1, TirosP]
type = ChangeState
value = 3010;709
triggerall = command = "tirosp"
triggerall = power >= 1500
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 710
trigger1 = command = "aura"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 750
trigger1 = command = "aura"
triggerall = power >= 1000
trigger1 = statetype = A
trigger1 = ctrl

[State -1, TirosP]
type = ChangeState
value = 712
triggerall = command = "golpechue02"
triggerall = power >= 1500
trigger1 = statetype = S
trigger1 = ctrl



;-------------------Golpes AR------------------------------------

[State -1, ]   
type = ChangeState
value =  701
trigger1 = command = "leishuar"
triggerall = power >= 100
trigger1 = statetype = A
trigger1 = ctrl


[State -1, ]   
type = ChangeState
value =  720
trigger1 = command = "leishuar2"
triggerall = power >= 300
trigger1 = statetype = A
trigger1 = ctrl

[State -1, ]    
type = ChangeState
value =  721
trigger1 = command = "golpechue07"
triggerall = power >= 200
trigger1 = statetype = A
trigger1 = ctrl


[State -1, ]    
type = ChangeState
value =  724
trigger1 = command = "golpechue06"
triggerall = power >= 250
trigger1 = statetype = A
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 727;810
;triggerall = var(59) <= 0
triggerall = command = "FF3"
;triggerall = command != "holddown"
;triggerall = stateno = 100
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 729;810
;triggerall = var(59) <= 0
triggerall = command = "FF4"
;triggerall = command != "holddown"
;triggerall = stateno = 100
triggerall = power >= 300
trigger1 = statetype = S
trigger1 = ctrl



;------------------------------Golpes ------------------------------------------


[State -1, ]
type = ChangeState
value = 450 
triggerall = power >= 150
;triggerall = numhelper(1550) = 0
;triggerall = var(30) != 1
;trigger1 = command = "granada"
trigger1 = command = "leishu1"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 705
trigger1 = command = "trava2"
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 730;725
trigger1 = command = "tiro01"
triggerall = power >= 300
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 732;726
trigger1 = command = "tiro02"
triggerall = power >= 400
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 70500
trigger1 = command = "trava1"
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 1800
trigger1 = command = "Golpe_Rapido01"
triggerall = power >= 150
trigger1 = statetype = S || statetype = A
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 1801
trigger1 = command = "Golpe_Rapido02"
triggerall = power >= 250
trigger1 = statetype = S || statetype = A
trigger1 = ctrl



[State -1, Standing Parry]
type=hitoverride
trigger1= var(59)<=0
trigger1= roundstate=2 && (statetype=S || stateno=5120)
trigger1= command="barreira"
trigger1= ctrl || (stateno=[708,730]) || stateno=5120
trigger1= var(21):=1
attr=SCA,NA,SA,HA,NP,SP,HP,NT,ST,HT,AA,AP
stateno=708
slot=0
time=5


[State -1, Standing Parry]
type=hitoverride
trigger1= var(59)<=0
trigger1= roundstate=2 && (statetype=A || stateno=5120)
trigger1= command="barreira"
trigger1= ctrl || (stateno=[718,730]) || stateno=5120
trigger1= var(21):=1
attr=SCA,NA,SA,HA,NP,SP,HP,NT,ST,HT,AA,AP
stateno=718
slot=0
time=5



[State -1, ]
type = ChangeState
value = 1500
triggerall = power >= 350
triggerall = numhelper(1550) = 0
triggerall = var(30) != 1
trigger1 = command = "granada"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 1000
trigger1 = command = "golpechue04"
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 1002
trigger1 = command = "golpechue05"
triggerall = power >= 200
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 1501
triggerall = numhelper(1550) > 0
triggerall = command = "granada"
;triggerall = power >= 200
trigger1 = statetype = S
trigger1 = ctrl




;===================================================================================================
;===================================================================================================


[State -1]   ;chute ar forte original
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]   ;chute ar forte original
type = ChangeState
value = 721
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "golpechue06"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 721
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "golpechue07"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 724
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "golpechue06"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]   ;chute ar forte original
type = ChangeState
value = 720
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leishuar2"
triggerall = stateno = 724
triggerall = movecontact = 1
trigger1 = statetype = A



[State -1]   ;chute ar forte original
type = ChangeState
value = 701
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leishuar"
triggerall = stateno = 724
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]   ;chute ar forte original
type = ChangeState
value = 720
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leishuar2"
triggerall = stateno = 1401
triggerall = movecontact = 1
trigger1 = statetype = A



[State -1]   ;chute ar forte original
type = ChangeState
value = 701
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leishuar"
triggerall = stateno = 1401
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]   ;chute ar forte original
type = ChangeState
value = 724
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "golpechue06"
triggerall = stateno = 611
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 724
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "golpechue07"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]   ;chute ar forte original
type = ChangeState
value = 721
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "golpechue07"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A


;Stand Light Punch

[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
;triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time > 10



[State -1, ]
type             = ChangeState
value            = 201
triggerall       = Command="x"
trigger1         = statetype = S
trigger1         = ctrl = 1
trigger2         = (stateno = 200) && (Time > 3) && (PrevStateNo != 201)


[State -1, varios socos 202]
type             = ChangeState
value            = 1602
triggerall       = Command="x"
trigger1         = statetype = S
trigger1         = ctrl = 1
trigger2         = (stateno = 200) && (Time > 10) && (PrevStateNo != 1602)
;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 201
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 201
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 203
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 230
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 203
triggerall = movecontact = 1
trigger1 = statetype = S

;----------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 203
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S



;---------------------------------------------------------------------------

[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
;triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6


[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 201
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 241
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------

[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 7
trigger3 = (stateno = 230) && time > 9


[State -1]
type = ChangeState
value = 231
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 231
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 241
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 700
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leishu1"
triggerall = stateno = 240
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 241
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 200
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Standing Strong Kick
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 241
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

[State -1]
type = ChangeState
value = 60
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "Superpulo"
triggerall = stateno = 410
triggerall = movecontact = 0
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 231
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 203
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 240
triggerall = movecontact = 1
trigger1 = statetype = S



[State -1]
type = ChangeState
value = 201
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 231
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 231
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S





;---------------------------------------------------------------------------
;Crouching Light Kick
;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno != 430
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = statetime >= 7
trigger3 = stateno = 1350 ;Air blocking

[State -1, varios socos 202]
type             = ChangeState
value            = 600
triggerall       = Command="z"
trigger1         = statetype = A
trigger1         = ctrl
trigger2         = stateno = 301 && movecontact
trigger3         = stateno = 302 && movecontact
trigger4         = stateno = 303 && movecontact

[State -1]
type = ChangeState
value = 630
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 600
triggerall = movecontact = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

[State -1]
type = ChangeState
value = 701
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 1205
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 1205
triggerall = movecontact = 1
trigger1 = statetype = A

;[State -1]
;type = ChangeState
;value = 611
;triggerall = Var(1) = 0
;triggerall = alive = 1
;triggerall = command = "SocoChao"
;triggerall = stateno = 707
;triggerall = movecontact = 1
;trigger1 = statetype = A


[State -1]
type = ChangeState
value = 701
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leishuar"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 640
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A



;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 1350 ;Air blocking

[State -1]
type = ChangeState
value = 640
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 630
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 701
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leishuar"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A



;---------------------------------------------------------------------------
;Jump Strong Kick
;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking


[State -1]
type = ChangeState
value = 610
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A

